# **引入**
* AI 智慧医疗是目前 AI 技术应用的一个热门领域，将 AI 技术用于辅助医疗工作者提高医疗的质量与效率，我觉得是非常有意义的事情。
* 在最近的新型冠状病毒肺炎疫情中，AI 技术在疫情防控上也出了一份自己的力量。
* 很多医院借助 AI 算法通过识别胸部 X 光片辅助医疗工作者诊断新冠肺炎，大大提高了诊断的效率。
* 通过胸部 X 光片进行肺炎检测这项技术其实也已经研究了很多年了，今天就来介绍并复现一篇由吴恩达哈佛大学团队在 2017 年发表的论文。

# **参考资料**
* 论文：[CheXNet: Radiologist-Level Pneumonia Detection on Chest X-Rays with Deep Learning](https://arxiv.org/abs/1711.05225)
* 参考实现：[arnoweng/CheXNet](https://github.com/arnoweng/CheXNet)
* 本项目：[jm12138/Paddle-CheXNe](https://github.com/jm12138/Paddle-CheXNet)

# **CheXNet**
* 即一个使用 ChestX-ray14 数据集训练的 121 层的深度卷积网络 (DenseNet)，该网络通过胸片识别肺炎的准确率已经和人类放射科医生持平甚至更高。
* 网络输入为人体正面扫描的胸片，输入时患肺炎的概率，为了更好的可视化，使用了热力图 (Class activation mapping)。
* 模型结构上采用 DenseNet 结构，并将网络最后的全连接层替换为一个 14 维二进制输出，并连接一个Sigmoid单元输出概率值，对应到 ChestX-ray14 数据集中 14 种疾病的检测上。

<img src="https://stanfordmlgroup.github.io/projects/chexnet/img/chex-main.svg" width="30%">
<img src="https://ai-studio-static-online.cdn.bcebos.com/a48bbcbf1c8e45a8beecef0b3d9e5d6c60699c1b749242968fb4e732a7971a58" width="50%">


# **数据集**
* ChestX-ray14（2017），目前是最大的开源数胸片数据集。
* 有来自 30805 个患者的 112120 个正面扫描 X 光片，以及利用 NLP 从相关放射学报告挖掘的 14 类疾病的图像标签（每个图像可以有多个标签）。
* 数据集含有 14 类常见的胸部病理，包括肺不张、变实、浸润、气胸、水肿、肺气肿、纤维变性、积液、肺炎、胸膜增厚、心脏肥大、结节、肿块和疝气。
* 文中将图片尺寸调整为 224 x 224，同时根据在 ImageNet 中图片的均值和偏差进行规范化，使用了随机水平翻转来做数据增强。

# **精度表现**
|     Pathology      | [Wang et al.](https://arxiv.org/abs/1705.02315) | [Yao et al.](https://arxiv.org/abs/1710.10501) | [CheXNet](https://arxiv.org/abs/1711.05225) | arnoweng/CheXNet | arnoweng/CheXNet Improved Model | Paddle-CheXNet |
| :----------------: | :--------------------------------------: | :--------------------------------------: | :--------------------------------------: | :---------------------: | :----------------: | :----------------: |
|    Atelectasis     |                  0.716                   |                  0.772                   |                  0.8094                  |         0.8294          |       0.8311       | 0.8292 |
|    Cardiomegaly    |                  0.807                   |                  0.904                   |                  0.9248                  |         0.9165          |       0.9220       | 0.9143 |
|      Effusion      |                  0.784                   |                  0.859                   |                  0.8638                  |         0.8870          |       0.8891       | 0.8876 |
|    Infiltration    |                  0.609                   |                  0.695                   |                  0.7345                  |         0.7143          |       0.7146       | 0.7118 |
|        Mass        |                  0.706                   |                  0.792                   |                  0.8676                  |         0.8597          |       0.8627       | 0.8647 |
|       Nodule       |                  0.671                   |                  0.717                   |                  0.7802                  |         0.7873          |       0.7883       | 0.7921 |
|     Pneumonia      |                  0.633                   |                  0.713                   |                  0.7680                  |         0.7745          |       0.7820       | 0.7684 |
|    Pneumothorax    |                  0.806                   |                  0.841                   |                  0.8887                  |         0.8726          |       0.8844       | 0.8771 |
|   Consolidation    |                  0.708                   |                  0.788                   |                  0.7901                  |         0.8142          |       0.8148       | 0.8161 |
|       Edema        |                  0.835                   |                  0.882                   |                  0.8878                  |         0.8932          |       0.8992       | 0.8987 |
|     Emphysema      |                  0.815                   |                  0.829                   |                  0.9371                  |         0.9254          |       0.9343       | 0.9302 |
|      Fibrosis      |                  0.769                   |                  0.767                   |                  0.8047                  |         0.8304          |       0.8385       | 0.8374 |
| Pleural Thickening |                  0.708                   |                  0.765                   |                  0.8062                  |         0.7831          |       0.7914       | 0.7962 |
|       Hernia       |                  0.767                   |                  0.914                   |                  0.9164                  |         0.9104          |       0.9206       | 0.9311 |
| Avg AUROCs | | | 0.841 | 0.843 | 0.848 | 0.847 |

# **同步项目代码**


```python
%cd ~

!git clone https://github.com.cnpmjs.org/jm12138/Paddle-CheXNet
```

# **解压数据集**


```python
%cd ~

!tar -xf data/data103487/images_001.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data103487/images_002.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data103487/images_003.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data103487/images_004.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data103487/images_005.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data103487/images_006.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data103487/images_007.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data103487/images_008.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data103487/images_009.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data103487/images_010.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data104006/images_011.tar.gz -C Paddle-CheXNet/dataset
!tar -xf data/data104006/images_012.tar.gz -C Paddle-CheXNet/dataset
```

    /home/aistudio


# **模型结构**
* 模型的具体结构如下图所示：

![](https://ai-studio-static-online.cdn.bcebos.com/864ca7dad49d4a88988675dc791ad465c104a0876d1f460996059283fd2dc467)

* 也可以使用下面的代码创建并打印模型结构


```python
%cd ~/Paddle-CheXNet/

import paddle
from chexnet.model import CheXNet
from chexnet.utility import N_CLASSES

# 创建一个模型
model = CheXNet(N_CLASSES)

# 打印模型结构
paddle.summary(model, (1, 3, 224, 224))
```

    /home/aistudio/Paddle-CheXNet
    -------------------------------------------------------------------------------
       Layer (type)         Input Shape          Output Shape         Param #  
    ===============================================================================
         Conv2D-1        [[1, 3, 224, 224]]   [1, 64, 112, 112]        9,408  
        BatchNorm-1     [[1, 64, 112, 112]]   [1, 64, 112, 112]         256  
       ConvBNLayer-1     [[1, 3, 224, 224]]   [1, 64, 112, 112]          0  
        MaxPool2D-1     [[1, 64, 112, 112]]    [1, 64, 56, 56]           0  
        BatchNorm-2      [[1, 64, 56, 56]]     [1, 64, 56, 56]          256  
         Conv2D-2        [[1, 64, 56, 56]]     [1, 128, 56, 56]        8,192  
      BNACConvLayer-1    [[1, 64, 56, 56]]     [1, 128, 56, 56]          0  
        BatchNorm-3      [[1, 128, 56, 56]]    [1, 128, 56, 56]         512  
         Conv2D-3        [[1, 128, 56, 56]]    [1, 32, 56, 56]        36,864  
      BNACConvLayer-2    [[1, 128, 56, 56]]    [1, 32, 56, 56]           0  
       DenseLayer-1      [[1, 64, 56, 56]]     [1, 96, 56, 56]           0  
        BatchNorm-4      [[1, 96, 56, 56]]     [1, 96, 56, 56]          384  
         Conv2D-4        [[1, 96, 56, 56]]     [1, 128, 56, 56]       12,288  
      BNACConvLayer-3    [[1, 96, 56, 56]]     [1, 128, 56, 56]          0  
        BatchNorm-5      [[1, 128, 56, 56]]    [1, 128, 56, 56]         512  
         Conv2D-5        [[1, 128, 56, 56]]    [1, 32, 56, 56]        36,864  
      BNACConvLayer-4    [[1, 128, 56, 56]]    [1, 32, 56, 56]           0  
       DenseLayer-2      [[1, 96, 56, 56]]     [1, 128, 56, 56]          0  
        BatchNorm-6      [[1, 128, 56, 56]]    [1, 128, 56, 56]         512  
         Conv2D-6        [[1, 128, 56, 56]]    [1, 128, 56, 56]       16,384  
      BNACConvLayer-5    [[1, 128, 56, 56]]    [1, 128, 56, 56]          0  
        BatchNorm-7      [[1, 128, 56, 56]]    [1, 128, 56, 56]         512  
         Conv2D-7        [[1, 128, 56, 56]]    [1, 32, 56, 56]        36,864  
      BNACConvLayer-6    [[1, 128, 56, 56]]    [1, 32, 56, 56]           0  
       DenseLayer-3      [[1, 128, 56, 56]]    [1, 160, 56, 56]          0  
        BatchNorm-8      [[1, 160, 56, 56]]    [1, 160, 56, 56]         640  
         Conv2D-8        [[1, 160, 56, 56]]    [1, 128, 56, 56]       20,480  
      BNACConvLayer-7    [[1, 160, 56, 56]]    [1, 128, 56, 56]          0  
        BatchNorm-9      [[1, 128, 56, 56]]    [1, 128, 56, 56]         512  
         Conv2D-9        [[1, 128, 56, 56]]    [1, 32, 56, 56]        36,864  
      BNACConvLayer-8    [[1, 128, 56, 56]]    [1, 32, 56, 56]           0  
       DenseLayer-4      [[1, 160, 56, 56]]    [1, 192, 56, 56]          0  
       BatchNorm-10      [[1, 192, 56, 56]]    [1, 192, 56, 56]         768  
         Conv2D-10       [[1, 192, 56, 56]]    [1, 128, 56, 56]       24,576  
      BNACConvLayer-9    [[1, 192, 56, 56]]    [1, 128, 56, 56]          0  
       BatchNorm-11      [[1, 128, 56, 56]]    [1, 128, 56, 56]         512  
         Conv2D-11       [[1, 128, 56, 56]]    [1, 32, 56, 56]        36,864  
     BNACConvLayer-10    [[1, 128, 56, 56]]    [1, 32, 56, 56]           0  
       DenseLayer-5      [[1, 192, 56, 56]]    [1, 224, 56, 56]          0  
       BatchNorm-12      [[1, 224, 56, 56]]    [1, 224, 56, 56]         896  
         Conv2D-12       [[1, 224, 56, 56]]    [1, 128, 56, 56]       28,672  
     BNACConvLayer-11    [[1, 224, 56, 56]]    [1, 128, 56, 56]          0  
       BatchNorm-13      [[1, 128, 56, 56]]    [1, 128, 56, 56]         512  
         Conv2D-13       [[1, 128, 56, 56]]    [1, 32, 56, 56]        36,864  
     BNACConvLayer-12    [[1, 128, 56, 56]]    [1, 32, 56, 56]           0  
       DenseLayer-6      [[1, 224, 56, 56]]    [1, 256, 56, 56]          0  
       DenseBlock-1      [[1, 64, 56, 56]]     [1, 256, 56, 56]          0  
       BatchNorm-14      [[1, 256, 56, 56]]    [1, 256, 56, 56]        1,024  
         Conv2D-14       [[1, 256, 56, 56]]    [1, 128, 56, 56]       32,768  
     BNACConvLayer-13    [[1, 256, 56, 56]]    [1, 128, 56, 56]          0  
        AvgPool2D-1      [[1, 128, 56, 56]]    [1, 128, 28, 28]          0  
     TransitionLayer-1   [[1, 256, 56, 56]]    [1, 128, 28, 28]          0  
       BatchNorm-15      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-15       [[1, 128, 28, 28]]    [1, 128, 28, 28]       16,384  
     BNACConvLayer-14    [[1, 128, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-16      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-16       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-15    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-7      [[1, 128, 28, 28]]    [1, 160, 28, 28]          0  
       BatchNorm-17      [[1, 160, 28, 28]]    [1, 160, 28, 28]         640  
         Conv2D-17       [[1, 160, 28, 28]]    [1, 128, 28, 28]       20,480  
     BNACConvLayer-16    [[1, 160, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-18      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-18       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-17    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-8      [[1, 160, 28, 28]]    [1, 192, 28, 28]          0  
       BatchNorm-19      [[1, 192, 28, 28]]    [1, 192, 28, 28]         768  
         Conv2D-19       [[1, 192, 28, 28]]    [1, 128, 28, 28]       24,576  
     BNACConvLayer-18    [[1, 192, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-20      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-20       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-19    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-9      [[1, 192, 28, 28]]    [1, 224, 28, 28]          0  
       BatchNorm-21      [[1, 224, 28, 28]]    [1, 224, 28, 28]         896  
         Conv2D-21       [[1, 224, 28, 28]]    [1, 128, 28, 28]       28,672  
     BNACConvLayer-20    [[1, 224, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-22      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-22       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-21    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-10     [[1, 224, 28, 28]]    [1, 256, 28, 28]          0  
       BatchNorm-23      [[1, 256, 28, 28]]    [1, 256, 28, 28]        1,024  
         Conv2D-23       [[1, 256, 28, 28]]    [1, 128, 28, 28]       32,768  
     BNACConvLayer-22    [[1, 256, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-24      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-24       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-23    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-11     [[1, 256, 28, 28]]    [1, 288, 28, 28]          0  
       BatchNorm-25      [[1, 288, 28, 28]]    [1, 288, 28, 28]        1,152  
         Conv2D-25       [[1, 288, 28, 28]]    [1, 128, 28, 28]       36,864  
     BNACConvLayer-24    [[1, 288, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-26      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-26       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-25    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-12     [[1, 288, 28, 28]]    [1, 320, 28, 28]          0  
       BatchNorm-27      [[1, 320, 28, 28]]    [1, 320, 28, 28]        1,280  
         Conv2D-27       [[1, 320, 28, 28]]    [1, 128, 28, 28]       40,960  
     BNACConvLayer-26    [[1, 320, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-28      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-28       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-27    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-13     [[1, 320, 28, 28]]    [1, 352, 28, 28]          0  
       BatchNorm-29      [[1, 352, 28, 28]]    [1, 352, 28, 28]        1,408  
         Conv2D-29       [[1, 352, 28, 28]]    [1, 128, 28, 28]       45,056  
     BNACConvLayer-28    [[1, 352, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-30      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-30       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-29    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-14     [[1, 352, 28, 28]]    [1, 384, 28, 28]          0  
       BatchNorm-31      [[1, 384, 28, 28]]    [1, 384, 28, 28]        1,536  
         Conv2D-31       [[1, 384, 28, 28]]    [1, 128, 28, 28]       49,152  
     BNACConvLayer-30    [[1, 384, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-32      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-32       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-31    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-15     [[1, 384, 28, 28]]    [1, 416, 28, 28]          0  
       BatchNorm-33      [[1, 416, 28, 28]]    [1, 416, 28, 28]        1,664  
         Conv2D-33       [[1, 416, 28, 28]]    [1, 128, 28, 28]       53,248  
     BNACConvLayer-32    [[1, 416, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-34      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-34       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-33    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-16     [[1, 416, 28, 28]]    [1, 448, 28, 28]          0  
       BatchNorm-35      [[1, 448, 28, 28]]    [1, 448, 28, 28]        1,792  
         Conv2D-35       [[1, 448, 28, 28]]    [1, 128, 28, 28]       57,344  
     BNACConvLayer-34    [[1, 448, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-36      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-36       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-35    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-17     [[1, 448, 28, 28]]    [1, 480, 28, 28]          0  
       BatchNorm-37      [[1, 480, 28, 28]]    [1, 480, 28, 28]        1,920  
         Conv2D-37       [[1, 480, 28, 28]]    [1, 128, 28, 28]       61,440  
     BNACConvLayer-36    [[1, 480, 28, 28]]    [1, 128, 28, 28]          0  
       BatchNorm-38      [[1, 128, 28, 28]]    [1, 128, 28, 28]         512  
         Conv2D-38       [[1, 128, 28, 28]]    [1, 32, 28, 28]        36,864  
     BNACConvLayer-37    [[1, 128, 28, 28]]    [1, 32, 28, 28]           0  
       DenseLayer-18     [[1, 480, 28, 28]]    [1, 512, 28, 28]          0  
       DenseBlock-2      [[1, 128, 28, 28]]    [1, 512, 28, 28]          0  
       BatchNorm-39      [[1, 512, 28, 28]]    [1, 512, 28, 28]        2,048  
         Conv2D-39       [[1, 512, 28, 28]]    [1, 256, 28, 28]       131,072  
     BNACConvLayer-38    [[1, 512, 28, 28]]    [1, 256, 28, 28]          0  
        AvgPool2D-2      [[1, 256, 28, 28]]    [1, 256, 14, 14]          0  
     TransitionLayer-2   [[1, 512, 28, 28]]    [1, 256, 14, 14]          0  
       BatchNorm-40      [[1, 256, 14, 14]]    [1, 256, 14, 14]        1,024  
         Conv2D-40       [[1, 256, 14, 14]]    [1, 128, 14, 14]       32,768  
     BNACConvLayer-39    [[1, 256, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-41      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-41       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-40    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-19     [[1, 256, 14, 14]]    [1, 288, 14, 14]          0  
       BatchNorm-42      [[1, 288, 14, 14]]    [1, 288, 14, 14]        1,152  
         Conv2D-42       [[1, 288, 14, 14]]    [1, 128, 14, 14]       36,864  
     BNACConvLayer-41    [[1, 288, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-43      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-43       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-42    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-20     [[1, 288, 14, 14]]    [1, 320, 14, 14]          0  
       BatchNorm-44      [[1, 320, 14, 14]]    [1, 320, 14, 14]        1,280  
         Conv2D-44       [[1, 320, 14, 14]]    [1, 128, 14, 14]       40,960  
     BNACConvLayer-43    [[1, 320, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-45      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-45       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-44    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-21     [[1, 320, 14, 14]]    [1, 352, 14, 14]          0  
       BatchNorm-46      [[1, 352, 14, 14]]    [1, 352, 14, 14]        1,408  
         Conv2D-46       [[1, 352, 14, 14]]    [1, 128, 14, 14]       45,056  
     BNACConvLayer-45    [[1, 352, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-47      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-47       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-46    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-22     [[1, 352, 14, 14]]    [1, 384, 14, 14]          0  
       BatchNorm-48      [[1, 384, 14, 14]]    [1, 384, 14, 14]        1,536  
         Conv2D-48       [[1, 384, 14, 14]]    [1, 128, 14, 14]       49,152  
     BNACConvLayer-47    [[1, 384, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-49      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-49       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-48    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-23     [[1, 384, 14, 14]]    [1, 416, 14, 14]          0  
       BatchNorm-50      [[1, 416, 14, 14]]    [1, 416, 14, 14]        1,664  
         Conv2D-50       [[1, 416, 14, 14]]    [1, 128, 14, 14]       53,248  
     BNACConvLayer-49    [[1, 416, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-51      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-51       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-50    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-24     [[1, 416, 14, 14]]    [1, 448, 14, 14]          0  
       BatchNorm-52      [[1, 448, 14, 14]]    [1, 448, 14, 14]        1,792  
         Conv2D-52       [[1, 448, 14, 14]]    [1, 128, 14, 14]       57,344  
     BNACConvLayer-51    [[1, 448, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-53      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-53       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-52    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-25     [[1, 448, 14, 14]]    [1, 480, 14, 14]          0  
       BatchNorm-54      [[1, 480, 14, 14]]    [1, 480, 14, 14]        1,920  
         Conv2D-54       [[1, 480, 14, 14]]    [1, 128, 14, 14]       61,440  
     BNACConvLayer-53    [[1, 480, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-55      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-55       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-54    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-26     [[1, 480, 14, 14]]    [1, 512, 14, 14]          0  
       BatchNorm-56      [[1, 512, 14, 14]]    [1, 512, 14, 14]        2,048  
         Conv2D-56       [[1, 512, 14, 14]]    [1, 128, 14, 14]       65,536  
     BNACConvLayer-55    [[1, 512, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-57      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-57       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-56    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-27     [[1, 512, 14, 14]]    [1, 544, 14, 14]          0  
       BatchNorm-58      [[1, 544, 14, 14]]    [1, 544, 14, 14]        2,176  
         Conv2D-58       [[1, 544, 14, 14]]    [1, 128, 14, 14]       69,632  
     BNACConvLayer-57    [[1, 544, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-59      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-59       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-58    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-28     [[1, 544, 14, 14]]    [1, 576, 14, 14]          0  
       BatchNorm-60      [[1, 576, 14, 14]]    [1, 576, 14, 14]        2,304  
         Conv2D-60       [[1, 576, 14, 14]]    [1, 128, 14, 14]       73,728  
     BNACConvLayer-59    [[1, 576, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-61      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-61       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-60    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-29     [[1, 576, 14, 14]]    [1, 608, 14, 14]          0  
       BatchNorm-62      [[1, 608, 14, 14]]    [1, 608, 14, 14]        2,432  
         Conv2D-62       [[1, 608, 14, 14]]    [1, 128, 14, 14]       77,824  
     BNACConvLayer-61    [[1, 608, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-63      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-63       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-62    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-30     [[1, 608, 14, 14]]    [1, 640, 14, 14]          0  
       BatchNorm-64      [[1, 640, 14, 14]]    [1, 640, 14, 14]        2,560  
         Conv2D-64       [[1, 640, 14, 14]]    [1, 128, 14, 14]       81,920  
     BNACConvLayer-63    [[1, 640, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-65      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-65       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-64    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-31     [[1, 640, 14, 14]]    [1, 672, 14, 14]          0  
       BatchNorm-66      [[1, 672, 14, 14]]    [1, 672, 14, 14]        2,688  
         Conv2D-66       [[1, 672, 14, 14]]    [1, 128, 14, 14]       86,016  
     BNACConvLayer-65    [[1, 672, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-67      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-67       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-66    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-32     [[1, 672, 14, 14]]    [1, 704, 14, 14]          0  
       BatchNorm-68      [[1, 704, 14, 14]]    [1, 704, 14, 14]        2,816  
         Conv2D-68       [[1, 704, 14, 14]]    [1, 128, 14, 14]       90,112  
     BNACConvLayer-67    [[1, 704, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-69      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-69       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-68    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-33     [[1, 704, 14, 14]]    [1, 736, 14, 14]          0  
       BatchNorm-70      [[1, 736, 14, 14]]    [1, 736, 14, 14]        2,944  
         Conv2D-70       [[1, 736, 14, 14]]    [1, 128, 14, 14]       94,208  
     BNACConvLayer-69    [[1, 736, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-71      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-71       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-70    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-34     [[1, 736, 14, 14]]    [1, 768, 14, 14]          0  
       BatchNorm-72      [[1, 768, 14, 14]]    [1, 768, 14, 14]        3,072  
         Conv2D-72       [[1, 768, 14, 14]]    [1, 128, 14, 14]       98,304  
     BNACConvLayer-71    [[1, 768, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-73      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-73       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-72    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-35     [[1, 768, 14, 14]]    [1, 800, 14, 14]          0  
       BatchNorm-74      [[1, 800, 14, 14]]    [1, 800, 14, 14]        3,200  
         Conv2D-74       [[1, 800, 14, 14]]    [1, 128, 14, 14]       102,400  
     BNACConvLayer-73    [[1, 800, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-75      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-75       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-74    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-36     [[1, 800, 14, 14]]    [1, 832, 14, 14]          0  
       BatchNorm-76      [[1, 832, 14, 14]]    [1, 832, 14, 14]        3,328  
         Conv2D-76       [[1, 832, 14, 14]]    [1, 128, 14, 14]       106,496  
     BNACConvLayer-75    [[1, 832, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-77      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-77       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-76    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-37     [[1, 832, 14, 14]]    [1, 864, 14, 14]          0  
       BatchNorm-78      [[1, 864, 14, 14]]    [1, 864, 14, 14]        3,456  
         Conv2D-78       [[1, 864, 14, 14]]    [1, 128, 14, 14]       110,592  
     BNACConvLayer-77    [[1, 864, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-79      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-79       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-78    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-38     [[1, 864, 14, 14]]    [1, 896, 14, 14]          0  
       BatchNorm-80      [[1, 896, 14, 14]]    [1, 896, 14, 14]        3,584  
         Conv2D-80       [[1, 896, 14, 14]]    [1, 128, 14, 14]       114,688  
     BNACConvLayer-79    [[1, 896, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-81      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-81       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-80    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-39     [[1, 896, 14, 14]]    [1, 928, 14, 14]          0  
       BatchNorm-82      [[1, 928, 14, 14]]    [1, 928, 14, 14]        3,712  
         Conv2D-82       [[1, 928, 14, 14]]    [1, 128, 14, 14]       118,784  
     BNACConvLayer-81    [[1, 928, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-83      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-83       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-82    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-40     [[1, 928, 14, 14]]    [1, 960, 14, 14]          0  
       BatchNorm-84      [[1, 960, 14, 14]]    [1, 960, 14, 14]        3,840  
         Conv2D-84       [[1, 960, 14, 14]]    [1, 128, 14, 14]       122,880  
     BNACConvLayer-83    [[1, 960, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-85      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-85       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-84    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-41     [[1, 960, 14, 14]]    [1, 992, 14, 14]          0  
       BatchNorm-86      [[1, 992, 14, 14]]    [1, 992, 14, 14]        3,968  
         Conv2D-86       [[1, 992, 14, 14]]    [1, 128, 14, 14]       126,976  
     BNACConvLayer-85    [[1, 992, 14, 14]]    [1, 128, 14, 14]          0  
       BatchNorm-87      [[1, 128, 14, 14]]    [1, 128, 14, 14]         512  
         Conv2D-87       [[1, 128, 14, 14]]    [1, 32, 14, 14]        36,864  
     BNACConvLayer-86    [[1, 128, 14, 14]]    [1, 32, 14, 14]           0  
       DenseLayer-42     [[1, 992, 14, 14]]   [1, 1024, 14, 14]          0  
       DenseBlock-3      [[1, 256, 14, 14]]   [1, 1024, 14, 14]          0  
       BatchNorm-88     [[1, 1024, 14, 14]]   [1, 1024, 14, 14]        4,096  
         Conv2D-88      [[1, 1024, 14, 14]]    [1, 512, 14, 14]       524,288  
     BNACConvLayer-87   [[1, 1024, 14, 14]]    [1, 512, 14, 14]          0  
        AvgPool2D-3      [[1, 512, 14, 14]]     [1, 512, 7, 7]           0  
     TransitionLayer-3  [[1, 1024, 14, 14]]     [1, 512, 7, 7]           0  
       BatchNorm-89       [[1, 512, 7, 7]]      [1, 512, 7, 7]         2,048  
         Conv2D-89        [[1, 512, 7, 7]]      [1, 128, 7, 7]        65,536  
     BNACConvLayer-88     [[1, 512, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-90       [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
         Conv2D-90        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-89     [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-43      [[1, 512, 7, 7]]      [1, 544, 7, 7]           0  
       BatchNorm-91       [[1, 544, 7, 7]]      [1, 544, 7, 7]         2,176  
         Conv2D-91        [[1, 544, 7, 7]]      [1, 128, 7, 7]        69,632  
     BNACConvLayer-90     [[1, 544, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-92       [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
         Conv2D-92        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-91     [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-44      [[1, 544, 7, 7]]      [1, 576, 7, 7]           0  
       BatchNorm-93       [[1, 576, 7, 7]]      [1, 576, 7, 7]         2,304  
         Conv2D-93        [[1, 576, 7, 7]]      [1, 128, 7, 7]        73,728  
     BNACConvLayer-92     [[1, 576, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-94       [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
         Conv2D-94        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-93     [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-45      [[1, 576, 7, 7]]      [1, 608, 7, 7]           0  
       BatchNorm-95       [[1, 608, 7, 7]]      [1, 608, 7, 7]         2,432  
         Conv2D-95        [[1, 608, 7, 7]]      [1, 128, 7, 7]        77,824  
     BNACConvLayer-94     [[1, 608, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-96       [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
         Conv2D-96        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-95     [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-46      [[1, 608, 7, 7]]      [1, 640, 7, 7]           0  
       BatchNorm-97       [[1, 640, 7, 7]]      [1, 640, 7, 7]         2,560  
         Conv2D-97        [[1, 640, 7, 7]]      [1, 128, 7, 7]        81,920  
     BNACConvLayer-96     [[1, 640, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-98       [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
         Conv2D-98        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-97     [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-47      [[1, 640, 7, 7]]      [1, 672, 7, 7]           0  
       BatchNorm-99       [[1, 672, 7, 7]]      [1, 672, 7, 7]         2,688  
         Conv2D-99        [[1, 672, 7, 7]]      [1, 128, 7, 7]        86,016  
     BNACConvLayer-98     [[1, 672, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-100      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-100        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-99     [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-48      [[1, 672, 7, 7]]      [1, 704, 7, 7]           0  
       BatchNorm-101      [[1, 704, 7, 7]]      [1, 704, 7, 7]         2,816  
        Conv2D-101        [[1, 704, 7, 7]]      [1, 128, 7, 7]        90,112  
     BNACConvLayer-100    [[1, 704, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-102      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-102        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-101    [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-49      [[1, 704, 7, 7]]      [1, 736, 7, 7]           0  
       BatchNorm-103      [[1, 736, 7, 7]]      [1, 736, 7, 7]         2,944  
        Conv2D-103        [[1, 736, 7, 7]]      [1, 128, 7, 7]        94,208  
     BNACConvLayer-102    [[1, 736, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-104      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-104        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-103    [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-50      [[1, 736, 7, 7]]      [1, 768, 7, 7]           0  
       BatchNorm-105      [[1, 768, 7, 7]]      [1, 768, 7, 7]         3,072  
        Conv2D-105        [[1, 768, 7, 7]]      [1, 128, 7, 7]        98,304  
     BNACConvLayer-104    [[1, 768, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-106      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-106        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-105    [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-51      [[1, 768, 7, 7]]      [1, 800, 7, 7]           0  
       BatchNorm-107      [[1, 800, 7, 7]]      [1, 800, 7, 7]         3,200  
        Conv2D-107        [[1, 800, 7, 7]]      [1, 128, 7, 7]        102,400  
     BNACConvLayer-106    [[1, 800, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-108      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-108        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-107    [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-52      [[1, 800, 7, 7]]      [1, 832, 7, 7]           0  
       BatchNorm-109      [[1, 832, 7, 7]]      [1, 832, 7, 7]         3,328  
        Conv2D-109        [[1, 832, 7, 7]]      [1, 128, 7, 7]        106,496  
     BNACConvLayer-108    [[1, 832, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-110      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-110        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-109    [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-53      [[1, 832, 7, 7]]      [1, 864, 7, 7]           0  
       BatchNorm-111      [[1, 864, 7, 7]]      [1, 864, 7, 7]         3,456  
        Conv2D-111        [[1, 864, 7, 7]]      [1, 128, 7, 7]        110,592  
     BNACConvLayer-110    [[1, 864, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-112      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-112        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-111    [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-54      [[1, 864, 7, 7]]      [1, 896, 7, 7]           0  
       BatchNorm-113      [[1, 896, 7, 7]]      [1, 896, 7, 7]         3,584  
        Conv2D-113        [[1, 896, 7, 7]]      [1, 128, 7, 7]        114,688  
     BNACConvLayer-112    [[1, 896, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-114      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-114        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-113    [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-55      [[1, 896, 7, 7]]      [1, 928, 7, 7]           0  
       BatchNorm-115      [[1, 928, 7, 7]]      [1, 928, 7, 7]         3,712  
        Conv2D-115        [[1, 928, 7, 7]]      [1, 128, 7, 7]        118,784  
     BNACConvLayer-114    [[1, 928, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-116      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-116        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-115    [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-56      [[1, 928, 7, 7]]      [1, 960, 7, 7]           0  
       BatchNorm-117      [[1, 960, 7, 7]]      [1, 960, 7, 7]         3,840  
        Conv2D-117        [[1, 960, 7, 7]]      [1, 128, 7, 7]        122,880  
     BNACConvLayer-116    [[1, 960, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-118      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-118        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-117    [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-57      [[1, 960, 7, 7]]      [1, 992, 7, 7]           0  
       BatchNorm-119      [[1, 992, 7, 7]]      [1, 992, 7, 7]         3,968  
        Conv2D-119        [[1, 992, 7, 7]]      [1, 128, 7, 7]        126,976  
     BNACConvLayer-118    [[1, 992, 7, 7]]      [1, 128, 7, 7]           0  
       BatchNorm-120      [[1, 128, 7, 7]]      [1, 128, 7, 7]          512  
        Conv2D-120        [[1, 128, 7, 7]]      [1, 32, 7, 7]         36,864  
     BNACConvLayer-119    [[1, 128, 7, 7]]      [1, 32, 7, 7]            0  
       DenseLayer-58      [[1, 992, 7, 7]]     [1, 1024, 7, 7]           0  
       DenseBlock-4       [[1, 512, 7, 7]]     [1, 1024, 7, 7]           0  
       BatchNorm-121     [[1, 1024, 7, 7]]     [1, 1024, 7, 7]         4,096  
    AdaptiveAvgPool2D-1  [[1, 1024, 7, 7]]     [1, 1024, 1, 1]           0  
         Linear-2           [[1, 1024]]            [1, 14]            14,350  
         Sigmoid-1           [[1, 14]]             [1, 14]               0  
        DenseNet-1       [[1, 3, 224, 224]]        [1, 14]               0  
    ===============================================================================
    Total params: 7,051,854
    Trainable params: 6,884,558
    Non-trainable params: 167,296
    -------------------------------------------------------------------------------
    Input size (MB): 0.57
    Forward/backward pass size (MB): 317.74
    Params size (MB): 26.90
    Estimated Total Size (MB): 345.22
    -------------------------------------------------------------------------------






    {'total_params': 7051854, 'trainable_params': 6884558}



# **模型训练**
* 使用如下命令启动模型训练
* 模型参数默认保存在 save 目录下


```python
%cd ~/Paddle-CheXNet/

!python train.py \
    --data_dir=dataset/images \
    --train_list=dataset/labels/train_list.txt \
    --val_list=dataset/labels/val_list.txt \
    --save_dir=save \
    --batch_size=128 \
    --learning_rate=0.001 \
    --decay_epochs=10,15,18 \
    --decay_factor=0.1
```

    Epoch 1/10
    step  10/614 - loss: 0.1637 - AUROC_Atelectasis: 0.5273 - AUROC_Cardiomegaly: 0.5718 - AUROC_Effusion: 0.5099 - AUROC_Infiltration: 0.5623 - AUROC_Mass: 0.4979 - AUROC_Nodule: 0.5241 - AUROC_Pneumonia: 0.5117 - AUROC_Pneumothorax: 0.5222 - AUROC_Consolidation: 0.5422 - AUROC_Edema: 0.5124 - AUROC_Emphysema: 0.5822 - AUROC_Fibrosis: 0.5647 - AUROC_Pleural_Thickening: 0.5287 - AUROC_Hernia: 0.5795 - AUROC_avg: 0.5384 - 3s/step
    step  20/614 - loss: 0.1908 - AUROC_Atelectasis: 0.5362 - AUROC_Cardiomegaly: 0.5684 - AUROC_Effusion: 0.6072 - AUROC_Infiltration: 0.5874 - AUROC_Mass: 0.5328 - AUROC_Nodule: 0.5464 - AUROC_Pneumonia: 0.4989 - AUROC_Pneumothorax: 0.5822 - AUROC_Consolidation: 0.5691 - AUROC_Edema: 0.5745 - AUROC_Emphysema: 0.5296 - AUROC_Fibrosis: 0.3818 - AUROC_Pleural_Thickening: 0.5311 - AUROC_Hernia: 0.6353 - AUROC_avg: 0.5486 - 3s/step
    step  30/614 - loss: 0.1639 - AUROC_Atelectasis: 0.5638 - AUROC_Cardiomegaly: 0.5591 - AUROC_Effusion: 0.6467 - AUROC_Infiltration: 0.6085 - AUROC_Mass: 0.5365 - AUROC_Nodule: 0.5333 - AUROC_Pneumonia: 0.5347 - AUROC_Pneumothorax: 0.6173 - AUROC_Consolidation: 0.6009 - AUROC_Edema: 0.6579 - AUROC_Emphysema: 0.5657 - AUROC_Fibrosis: 0.4574 - AUROC_Pleural_Thickening: 0.5511 - AUROC_Hernia: 0.7023 - AUROC_avg: 0.5811 - 3s/step
    step  40/614 - loss: 0.1770 - AUROC_Atelectasis: 0.5913 - AUROC_Cardiomegaly: 0.5745 - AUROC_Effusion: 0.6787 - AUROC_Infiltration: 0.6205 - AUROC_Mass: 0.5434 - AUROC_Nodule: 0.5390 - AUROC_Pneumonia: 0.5726 - AUROC_Pneumothorax: 0.6446 - AUROC_Consolidation: 0.6464 - AUROC_Edema: 0.6982 - AUROC_Emphysema: 0.6008 - AUROC_Fibrosis: 0.4905 - AUROC_Pleural_Thickening: 0.5543 - AUROC_Hernia: 0.6165 - AUROC_avg: 0.5979 - 3s/step
    step  50/614 - loss: 0.1735 - AUROC_Atelectasis: 0.6097 - AUROC_Cardiomegaly: 0.5845 - AUROC_Effusion: 0.7038 - AUROC_Infiltration: 0.6165 - AUROC_Mass: 0.5543 - AUROC_Nodule: 0.5370 - AUROC_Pneumonia: 0.6032 - AUROC_Pneumothorax: 0.6644 - AUROC_Consolidation: 0.6562 - AUROC_Edema: 0.7222 - AUROC_Emphysema: 0.6222 - AUROC_Fibrosis: 0.5359 - AUROC_Pleural_Thickening: 0.5705 - AUROC_Hernia: 0.6369 - AUROC_avg: 0.6155 - 3s/step


# **精度测试**
* 使用如下指令完成模型精度测试
* 默认使用训练完成的预训练模型


```python
%cd ~/Paddle-CheXNet/

!python eval.py \
    --data_dir=dataset/images \
    --test_list=dataset/labels/test_list.txt \
    --batch_size=128 \
    --ckpt=pretrained_models/model_paddle.pdparams
```

    /home/aistudio/Paddle-CheXNet
    W0830 12:47:48.729317  5420 device_context.cc:404] Please NOTE: device: 0, GPU Compute Capability: 7.0, Driver API Version: 10.1, Runtime API Version: 10.1
    W0830 12:47:48.734786  5420 device_context.cc:422] device: 0, cuDNN Version: 7.6.
    => loading checkpoint
    => loaded checkpoint
      0%|                                                   | 0/176 [00:00<?, ?it/s]/opt/conda/envs/python35-paddle120-env/lib/python3.7/site-packages/paddle/tensor/creation.py:125: DeprecationWarning: `np.object` is a deprecated alias for the builtin `object`. To silence this warning, use `object` by itself. Doing this will not modify any behavior and is safe.
    Deprecated in NumPy 1.20; for more details and guidance: https://numpy.org/devdocs/release/1.20.0-notes.html#deprecations
      if data.dtype == np.object:
    100%|█████████████████████████████████████████| 176/176 [14:11<00:00,  4.84s/it]
    The final AUROCs:
    The average AUROC is 0.847
    The AUROC of Atelectasis is 0.8292392176490241
    The AUROC of Cardiomegaly is 0.9142859299652238
    The AUROC of Effusion is 0.8875584024095078
    The AUROC of Infiltration is 0.711814559849058
    The AUROC of Mass is 0.8647347811493854
    The AUROC of Nodule is 0.7921467608091082
    The AUROC of Pneumonia is 0.7684077120089262
    The AUROC of Pneumothorax is 0.8770951989569952
    The AUROC of Consolidation is 0.8160893266094902
    The AUROC of Edema is 0.8986931866913855
    The AUROC of Emphysema is 0.9302391831183919
    The AUROC of Fibrosis is 0.837411708221408
    The AUROC of Pleural_Thickening is 0.7962435140282585
    The AUROC of Hernia is 0.9311000806021127


# **总结**
* 使用 Paddle 框架重新实现了 CheXNet 并模型训练和验证的操作。
* 在精度表现上，转换的参考项目模型参数的精度表现与标称的精度基本一致。
* 与 Paper 给出的精度数据也基本相似，甚至稍微有些许提升。
